/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.network;

import com.google.common.collect.ImmutableList;
import dev.ftb.extendedexchange.menu.ArcaneTabletMenu;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketArcaneTabletRecipeTransfer {
    private final Int2ObjectMap<List<ItemStack>> stacksMap;
    private final boolean maxTransfer;

    public PacketArcaneTabletRecipeTransfer(Int2ObjectMap<List<ItemStack>> stacksMap, boolean maxTransfer) {
        this.stacksMap = stacksMap;
        this.maxTransfer = maxTransfer;
    }

    public PacketArcaneTabletRecipeTransfer(FriendlyByteBuf buf) {
        this.stacksMap = new Int2ObjectOpenHashMap();
        int nSlots = buf.m_130242_();
        for (int i = 0; i < nSlots; ++i) {
            int slot = buf.m_130242_();
            int nStacks = buf.m_130242_();
            List stacks = IntStream.range(0, nStacks).mapToObj(j -> buf.m_130267_()).collect(Collectors.toList());
            this.stacksMap.put(slot, (Object)ImmutableList.copyOf(stacks));
        }
        this.maxTransfer = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.stacksMap.size());
        this.stacksMap.forEach((index, stacks) -> {
            buf.m_130130_(index.intValue());
            buf.m_130130_(stacks.size());
            stacks.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130055_(arg_0));
        });
        buf.writeBoolean(this.maxTransfer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            AbstractContainerMenu patt2124$temp;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (patt2124$temp = player.f_36096_) instanceof ArcaneTabletMenu) {
                ArcaneTabletMenu tabletMenu = (ArcaneTabletMenu)patt2124$temp;
                tabletMenu.onRecipeTransfer(this.stacksMap, this.maxTransfer);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

